/*
 * Decompiled with CFR 0.152.
 */
package hughai.mapping;

import com.springrts.ai.oo.clb.Map;
import hughai.CSAI;
import hughai.PlayerObjects;
import hughai.VoiceCommandHandler;
import hughai.basictypes.Int2;
import hughai.basictypes.TerrainPos;
import hughai.loader.utils.TransLoadStorage;
import hughai.ui.MainUI;
import hughai.utils.Formatting;
import hughai.utils.LogFile;
import hughai.utils.MapHelper;
import hughai.utils.XmlHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HeightMap {
    CSAI csai;
    LogFile logFile;
    Map gameMap;
    PlayerObjects playerObjects;
    private float[][] heightMap;
    public static final int granularity = 1;
    String version = "0.2";

    public float getElevationAt(HeightMapPos heightMapPos) {
        this.GetHeightMap();
        return this.heightMap[heightMapPos.x][heightMapPos.y];
    }

    public float getElevationAt(TerrainPos terrainPos) {
        this.GetHeightMap();
        HeightMapPos heightMapPos = HeightMapPos.fromTerrainPos(terrainPos);
        return this.getElevationAt(heightMapPos);
    }

    public HeightMap(PlayerObjects playerObjects) {
        this.csai = playerObjects.getCSAI();
        this.logFile = playerObjects.getLogFile();
        this.gameMap = playerObjects.getAicallback().getMap();
        this.playerObjects = playerObjects;
        this.csai.RegisterVoiceCommand("showheightmap", new VoiceShowHeightMap());
        playerObjects.getMainUI().registerButton("Dump heightmap distribution", new ButtonHeightDistribution());
        playerObjects.getMainUI().registerButton("Calculate heightmap", new ButtonCalculateHeightMap());
        playerObjects.getMainUI().registerButton("Get heightmap from cache", new ButtonGetHeightMapFromCache());
    }

    void showHeightMap(int n) {
        float[][] fArray = this.GetHeightMap();
        int n2 = fArray.length;
        int n3 = fArray[0].length;
        boolean[][] blArray = new boolean[n2][n3];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                blArray[i][j] = fArray[i][j] >= (float)n;
            }
        }
        this.playerObjects.getDrawingUtils().DrawMap(blArray);
    }

    protected void finalize() {
        System.out.println(this.getClass().getSimpleName() + ".finalize()");
    }

    private float[][] GetHeightMap() {
        if (this.heightMap != null) {
            return this.heightMap;
        }
        if (this.LoadCoreStorage()) {
            return this.heightMap;
        }
        if (this.LoadCache()) {
            this.SaveCoreStorage();
            return this.heightMap;
        }
        this.calculateHeightMap();
        this.SaveCache();
        this.SaveCoreStorage();
        return this.heightMap;
    }

    public void calculateHeightMap() {
        this.logFile.WriteLine("Getting heightmap, this could take a while... ");
        int n = this.gameMap.getWidth();
        int n2 = this.gameMap.getHeight();
        this.heightMap = new float[n + 1][n2 + 1];
        for (int i = 0; i < n + 1; ++i) {
            for (int j = 0; j < n2 + 1; ++j) {
                this.heightMap[i][j] = this.gameMap.getElevationAt((float)(i * this.playerObjects.getMaps().getMovementMaps().SQUARE_SIZE), (float)(j * this.playerObjects.getMaps().getMovementMaps().SQUARE_SIZE));
            }
        }
    }

    boolean LoadCoreStorage() {
        Object object = TransLoadStorage.getInstance().getAttribute("heightmap");
        if (object != null) {
            this.logFile.WriteLine("retrieved height map from trans reload cache");
            this.heightMap = (float[][])object;
            return true;
        }
        return false;
    }

    void SaveCoreStorage() {
        this.logFile.WriteLine("storing heightmap in transcache");
        TransLoadStorage.getInstance().setAttribute("heightmap", this.heightMap);
        System.out.println("after storage, value in cache is: " + TransLoadStorage.getInstance().getAttribute("heightmap"));
    }

    String getCacheFilepath() {
        String string = this.gameMap.getName();
        return this.csai.getCacheDirectoryPath() + File.separator + string + "_heightmap" + "_" + this.playerObjects.getAicallback().getSkirmishAI().getTeamId() + "_" + this.version + ".dat";
    }

    void SaveCacheOld() {
        this.logFile.WriteLine("saving height map to cache...");
        String string = this.getCacheFilepath();
        Document document = XmlHelper.CreateDom();
        Element element = XmlHelper.AddChild(document.getDocumentElement(), "metadata");
        element.setAttribute("type", "HeightMap");
        element.setAttribute("map", this.gameMap.getName());
        element.setAttribute("version", this.version);
        element.setAttribute("mapheight", "" + this.gameMap.getHeight());
        element.setAttribute("mapwidth", "" + this.gameMap.getWidth());
        Element element2 = XmlHelper.AddChild(document.getDocumentElement(), "heights");
        for (int i = 0; i < this.gameMap.getWidth() + 1; ++i) {
            for (int j = 0; j < this.gameMap.getHeight() + 1; ++j) {
                Element element3 = XmlHelper.AddChild(element2, "height");
                element3.setAttribute("height", "" + this.heightMap[i][j]);
            }
        }
        XmlHelper.SaveDom(document, string);
        this.logFile.WriteLine(" ... done");
    }

    void SaveCache() {
        try {
            this.logFile.WriteLine("saving height map to cache...");
            String string = this.getCacheFilepath();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);
            for (int i = 0; i < this.gameMap.getWidth() + 1; ++i) {
                for (int j = 0; j < this.gameMap.getHeight() + 1; ++j) {
                    objectOutputStream.writeFloat(this.heightMap[i][j]);
                }
            }
            objectOutputStream.close();
            bufferedOutputStream.close();
            this.logFile.WriteLine(" ... done");
        }
        catch (Exception exception) {
            this.logFile.WriteLine(Formatting.exceptionToStackTrace(exception));
            throw new RuntimeException(exception);
        }
    }

    boolean LoadCache() {
        try {
            if (new File(this.getCacheFilepath()).exists()) {
                this.logFile.WriteLine("Loading heightmap from cache...");
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.getCacheFilepath()));
                ObjectInputStream objectInputStream = new ObjectInputStream(bufferedInputStream);
                int n = this.gameMap.getWidth();
                int n2 = this.gameMap.getHeight();
                this.heightMap = new float[n + 1][n2 + 1];
                int n3 = 0;
                for (int i = 0; i < this.gameMap.getWidth() + 1; ++i) {
                    for (int j = 0; j < this.gameMap.getHeight() + 1; ++j) {
                        this.heightMap[i][j] = objectInputStream.readFloat();
                        n3 += 4;
                    }
                }
                objectInputStream.close();
                bufferedInputStream.close();
                this.logFile.WriteLine(" ... done.");
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            this.logFile.WriteLine(Formatting.exceptionToStackTrace(exception));
            throw new RuntimeException(exception);
        }
    }

    class ButtonHeightDistribution
    implements MainUI.ButtonHandler {
        ButtonHeightDistribution() {
        }

        @Override
        public void go() {
            float[][] fArray = HeightMap.this.GetHeightMap();
            HeightMap.this.logFile.WriteLine("heightmap distribution:");
            new MapHelper(HeightMap.this.playerObjects).DumpMapDistribution(fArray);
        }
    }

    class ButtonGetHeightMapFromCache
    implements MainUI.ButtonHandler {
        ButtonGetHeightMapFromCache() {
        }

        @Override
        public void go() {
            HeightMap.this.LoadCache();
        }
    }

    class ButtonCalculateHeightMap
    implements MainUI.ButtonHandler {
        ButtonCalculateHeightMap() {
        }

        @Override
        public void go() {
            HeightMap.this.calculateHeightMap();
        }
    }

    class VoiceShowHeightMap
    implements VoiceCommandHandler {
        VoiceShowHeightMap() {
        }

        @Override
        public void commandReceived(String string, String[] stringArray, int n) {
            int n2 = Integer.parseInt(stringArray[2]);
            HeightMap.this.csai.sendTextMessage("drawing height map for contour height " + n2);
            HeightMap.this.showHeightMap(n2);
        }
    }

    public static class HeightMapPos
    extends Int2 {
        public HeightMapPos() {
        }

        public HeightMapPos(Int2 int2) {
            this.x = int2.x;
            this.y = int2.y;
        }

        public HeightMapPos(int n, int n2) {
            super(n, n2);
        }

        public TerrainPos toTerrainPos() {
            return new TerrainPos(this.x * 8 * 1, 0.0f, this.y * 8 * 1);
        }

        public static HeightMapPos fromTerrainPos(TerrainPos terrainPos) {
            return new HeightMapPos((int)terrainPos.x / 8 / 1, (int)terrainPos.z / 8 / 1);
        }
    }
}

