/*
 * Decompiled with CFR 0.152.
 */
package hughai.utils;

import hughai.PlayerObjects;
import hughai.utils.Config;
import hughai.utils.ConfigFileReadWriter;
import hughai.utils.ConfigStartScriptReader;
import hughai.utils.ReflectionHelper;
import java.util.HashMap;

public class ConfigController {
    PlayerObjects playerObjects;
    ReflectionHelper reflectionHelper;
    HashMap<ConfigSource, Config> configBySource = new HashMap();

    public ConfigController(PlayerObjects playerObjects) {
        this.playerObjects = playerObjects;
        this.reflectionHelper = new ReflectionHelper(playerObjects);
        this.init();
    }

    void debug(Object object) {
        this.playerObjects.getLogFile().writeLine("ConfigController: " + object);
    }

    void init() {
        this.debug("init()");
        this.debug("restoring from xml...");
        this.restoreFromSource(ConfigSource.XmlFile);
        this.debug("restoring from startscript...");
        this.restoreFromSource(ConfigSource.StartScript);
        this.debug("restoring from working copy...");
        this.restoreFromSource(ConfigSource.WorkingCopy);
    }

    public void copyConfig(ConfigSource configSource, ConfigSource configSource2) {
        if (!this.canWriteBackToSource(configSource2)) {
            throw new RuntimeException("Can't copy to config " + (Object)((Object)configSource2));
        }
    }

    public void writeConfigBackToSource(ConfigSource configSource) {
        if (!this.canWriteBackToSource(configSource)) {
            throw new RuntimeException("Can't write to config source " + (Object)((Object)configSource));
        }
        switch (configSource) {
            default: 
        }
        throw new RuntimeException("Unhandled configsource " + (Object)((Object)configSource));
    }

    public void restoreFromSource(ConfigSource configSource) {
        if (!this.canRestoreFromSource(configSource)) {
            this.debug("Can't restore from config source for config source " + (Object)((Object)configSource));
            throw new RuntimeException("Can't restore from config source for config source " + (Object)((Object)configSource));
        }
        if (!this.configBySource.containsKey((Object)configSource)) {
            this.debug("creating new config for " + (Object)((Object)configSource));
            this.configBySource.put(configSource, new Config(this.playerObjects));
        }
        Config config = this.configBySource.get((Object)configSource);
        this.debug("created blank config object");
        switch (configSource) {
            case XmlFile: {
                this.debug("creating configfilereadwriter...");
                ConfigFileReadWriter<Config> configFileReadWriter = new ConfigFileReadWriter<Config>(this.playerObjects);
                this.debug("calling loadconfig...");
                configFileReadWriter.loadConfig(config);
                break;
            }
            case StartScript: {
                ConfigStartScriptReader<Config> configStartScriptReader = new ConfigStartScriptReader<Config>(this.playerObjects);
                configStartScriptReader.loadConfig(config);
                break;
            }
            case WorkingCopy: {
                this.integrateSourcesToWorkingCopy(config);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled configsource " + (Object)((Object)configSource));
            }
        }
    }

    void integrateSourcesToWorkingCopy(Config config) {
        this.debug("copying xmlfile config to workingcopy config...");
        this.reflectionHelper.deepCopy(this.getConfig(ConfigSource.XmlFile), config);
        this.debug("copying startscript config to workingcopy config...");
        this.reflectionHelper.deepCopyNonNullOnly(this.getConfig(ConfigSource.StartScript), config);
    }

    public boolean canWriteBackToSource(ConfigSource configSource) {
        switch (configSource) {
            case XmlFile: {
                return true;
            }
        }
        return false;
    }

    public boolean canRestoreFromSource(ConfigSource configSource) {
        switch (configSource) {
            case XmlFile: 
            case StartScript: 
            case WorkingCopy: {
                return true;
            }
        }
        return false;
    }

    public Config getConfig() {
        return this.getConfig(ConfigSource.WorkingCopy);
    }

    public Config getConfig(ConfigSource configSource) {
        return this.configBySource.get((Object)configSource);
    }

    public static enum ConfigSource {
        XmlFile,
        StartScript,
        WorkingCopy;

    }
}

